--------------------------------------------------------------
--                                                          --
--    Copyright 1993 Altera Corporation                     --
--    VHDL example for 4 bit counter                        --
--    Description : 4 bit counter.                          --
--                                                          --
--------------------------------------------------------------
library pack1076;
use pack1076.pack1076.all;

library synth;
use synth.stdsynth.all;

entity COUNT4 is

	port(CLK, RST, ENABLE, LOAD : in VLBIT;
             DATA: INOUT VLBIT_VECTOR (3 downto 0));

end COUNT4;

architecture MAXPLUS of COUNT4 is
        constant ONE : VLBIT_VECTOR(0 downto 0) := "1";
        signal COUNT : VLBIT_VECTOR(4 downto 0) ;
begin

	CNT: process
		begin
                     wait until (CLK'event and CLK = '1') or rst = '1' ;
                     if (CLK'event and CLK = '1') then
                        if (LOAD = '1') then
                           COUNT(3 downto 0) <= DATA;
                        else
                           COUNT <= addum(COUNT(3 downto 0), ONE);
                        end if;
                     end if;
                     if rst = '1' then
                          COUNT <= "00000";
                     end if;

	end process CNT;

         DATA <= COUNT(3 downto 0) WHEN (ENABLE = '1') else "ZZZZ";

end MAXPLUS;
